<?php
function sendMessage($chat_id, $text, $keyboard = null) {
    $payload = ['chat_id' => $chat_id, 'text' => $text];
    if ($keyboard) {
        $payload['reply_markup'] = json_encode(['inline_keyboard' => $keyboard], JSON_UNESCAPED_UNICODE);
    }

    $url = API_URL . "sendMessage";
    $opts = [
        "http" => [
            "method"  => "POST",
            "header"  => "Content-Type: application/x-www-form-urlencoded",
            "content" => http_build_query($payload),
        ]
    ];
    $context = stream_context_create($opts);
    file_get_contents($url, false, $context);
}
?>