<?php
// ---------- تنظیمات ----------
define('API_KEY', '8136294399:AAE0pIA12SbJK66RbPDQWe5gFksSgvsbClY');
define('ADMIN_ID', 1018767556); // آیدی عددی ادمین
define('BOT_PASSWORD', 'Ars3663');

$playersFile = 'players.json';
$gameFile = 'game.json';
$accessFile = 'access.json';
$statsFile = 'stats.json';
$aliasesFile = 'aliases.json';

// ---------- توابع عمومی ----------
function bot($method, $datas = []) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function send($chat_id, $text, $parse_mode = null, $reply_markup = null) {
    $data = ['chat_id' => $chat_id, 'text' => $text];
    if ($parse_mode) $data['parse_mode'] = $parse_mode;
    if ($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    bot('sendMessage', $data);
}

function loadData($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) : [];
}

function saveData($file, $data) {
    file_put_contents($file, json_encode($data));
}

function sendMainPanel($chat_id) {
    $keyboard = [
        [['text' => '/join'], ['text' => '/leave']],
        [['text' => '/start_game'], ['text' => '/fire']],
        [['text' => '/setname'], ['text' => '/stats']],
        [['text' => '/setmode'], ['text' => '/help']]
    ];
    send($chat_id, "دستورات را از طریق پنل زیر انتخاب کن:", null, ['keyboard' => $keyboard, 'resize_keyboard' => true]);
}

// ---------- داستان مودها ----------
$modesStory = [
    'classic' => "*مود کلاسیک:*\nدر این مود همه‌چیز ساده‌ست. یه تفنگ، یه گلوله، چند دیوانه... هرکس جرأت داره ماشه رو بکشه، زنده می‌مونه... یا نه.",
    'revenge' => "*مود کینه‌جویانه:*\nاگه کسی تو رو بکشه، در بازی بعدی می‌تونی ازش انتقام بگیری!",
    'fear' => "*مود ترس:*\nخاموشی، سکوت، انتظار... ماشه رو بکش یا بمیر!"
];

// ---------- مدیریت پیام ----------
$update = json_decode(file_get_contents('php://input'), true);
$message = $update['message'] ?? null;

if ($message) {
    $chat_id = $message['chat']['id'];
    $from_id = $message['from']['id'];
    $name = $message['from']['first_name'] ?? '';
    $text = trim($message['text'] ?? '');

    // فایل‌ها
    $players = loadData($playersFile);
    $game = loadData($gameFile);
    $access = loadData($accessFile);
    $stats = loadData($statsFile);
    $aliases = loadData($aliasesFile);

    $alias = $aliases[$from_id] ?? $name;

    // ---------- بررسی دسترسی ----------
    if (!isset($access[$from_id])) {
        if ($text == '/start') {
            send($chat_id, "🎯 *به بازی مرگ خوش اومدی!*\n\nبرای ورود باید رمز عبور رو بزنی.\n\n*آیا جرأت ورود به این بازی مرگبار رو داری؟*", "Markdown");
        } elseif ($text == BOT_PASSWORD) {
            $access[$from_id] = true;
            saveData($accessFile, $access);
            send($chat_id, "✅ *دسترسی تأیید شد!*\n\nحالا می‌تونی وارد بازی بشی...\nبرای شروع، دستور /join رو بزن.", "Markdown");
            sendMainPanel($chat_id);
        } else {
            send($chat_id, "❌ *رمز اشتباهه!* \nیا اشتباه تایپ کردی یا نمی‌خوای زنده بمونی...", "Markdown");
        }
        return;
    }

    // ---------- دستورات ----------
    if ($text == '/start') {
        send($chat_id, "💀 *به بازی رولت روسی خوش اومدی!*\n\nاز دکمه‌ها برای اجرای دستورات استفاده کن.", "Markdown");
        sendMainPanel($chat_id);
    }

    elseif (str_starts_with($text, '/setname')) {
        $aliasName = trim(str_replace('/setname', '', $text));
        if ($aliasName) {
            $aliases[$from_id] = $aliasName;
            saveData($aliasesFile, $aliases);
            send($chat_id, "✏️ نام مستعار شما به '$aliasName' تنظیم شد.");
        } else {
            send($chat_id, "⚠️ لطفاً بعد از /setname یک نام بنویس.");
        }
    }

    elseif ($text == '/stats') {
        $userStats = $stats[$from_id] ?? ['wins' => 0, 'deaths' => 0, 'plays' => 0];
        send($chat_id, "📊 آمار شما:\nبردها: {$userStats['wins']}\nمرگ‌ها: {$userStats['deaths']}\nتعداد بازی‌ها: {$userStats['plays']}");
    }

    elseif (str_starts_with($text, '/setmode')) {
        $mode = trim(str_replace('/setmode', '', $text));
        if (isset($modesStory[$mode])) {
            $game['mode'] = $mode;
            saveData($gameFile, $game);
            send($chat_id, "🎮 مود بازی به '$mode' تنظیم شد.");
            send($chat_id, $modesStory[$mode], "Markdown");
        } else {
            send($chat_id, "⚠️ مود نامعتبر. مودهای موجود: classic ، revenge ، fear");
        }
    }

    elseif ($text == '/help') {
        $help = "🆘 راهنمای بازی:\n\n/start - شروع و دریافت راهنما\n/join - ورود به بازی\n/leave - خروج از بازی\n/setname [نام] - انتخاب نام مستعار\n/stats - دیدن آمار\n/setmode [classic|revenge|fear] - تنظیم مود بازی\n/start_game - شروع بازی (فقط ادمین)\n/fire - کشیدن ماشه\n/end - پایان بازی (فقط ادمین)\n\nمودها:";
        foreach ($modesStory as $desc) {
            $help .= "\n\n$desc";
        }
        send($chat_id, $help, "Markdown");
    }

    elseif ($text == '/join') {
        if (!empty($game['started'])) {
            send($chat_id, "🚫 بازی در حال اجراست.");
        } elseif (!in_array($from_id, $players)) {
            $players[] = $from_id;
            saveData($playersFile, $players);
            send($chat_id, "☠️ $alias به بازی پیوست.");
        } else {
            send($chat_id, "⚠️ قبلاً وارد بازی شدی.");
        }
    }

    elseif ($text == '/leave') {
        if (($key = array_search($from_id, $players)) !== false) {
            unset($players[$key]);
            saveData($playersFile, array_values($players));
            send($chat_id, "🚶 $alias از بازی خارج شد.");
        } else {
            send($chat_id, "❓ شما در بازی نیستید.");
        }
    }

    elseif ($text == '/start_game' && $from_id == ADMIN_ID) {
        if (count($players) < 2) {
            send($chat_id, "🧍‍♂️ حداقل ۲ بازیکن نیاز است.");
        } else {
            foreach ($players as $pid) {
                $stats[$pid]['plays'] = ($stats[$pid]['plays'] ?? 0) + 1;
            }
            $startIndex = rand(0, count($players) - 1);
            $game = [
                'started' => true,
                'players' => $players,
                'current' => $startIndex,
                'mode' => $game['mode'] ?? 'classic'
            ];
            saveData($gameFile, $game);
            $list = "🎬 *بازی شروع شد!*\n\nبازیکنان:\n";
            foreach ($players as $pid) {
                $a = $aliases[$pid] ?? $pid;
                $list .= "🔫 [$a](tg://user?id=$pid)\n";
            }
            $first = $game['players'][$startIndex];
            send($chat_id, "$list\n\n🔥 نوبت اول: [{$aliases[$first]}](tg://user?id=$first)", "Markdown");
            saveData($statsFile, $stats);
        }
    }

    elseif ($text == '/end' && $from_id == ADMIN_ID) {
        @unlink($playersFile);
        @unlink($gameFile);
        send($chat_id, "🛑 بازی متوقف شد.");
    }

    elseif ($text == '/fire') {
        if (empty($game['started'])) {
            send($chat_id, "⏳ بازی هنوز شروع نشده.");
            return;
        }
        $currentPlayer = $game['players'][$game['current']];
        if ($from_id != $currentPlayer) {
            send($chat_id, "❗ نوبت شما نیست!");
            return;
        }

        $bullet = rand(1, 6);
        if ($bullet == 1) {
            send($chat_id, "💥 [{$alias}](tg://user?id=$from_id) ماشه رو کشید و *مُرد!*", "Markdown");
            $stats[$from_id]['deaths'] = ($stats[$from_id]['deaths'] ?? 0) + 1;
            unset($game['players'][$game['current']]);
            $game['players'] = array_values($game['players']);
            if (count($game['players']) == 1) {
                $winner = $game['players'][0];
                $stats[$winner]['wins'] = ($stats[$winner]['wins'] ?? 0) + 1;
                send($chat_id, "🏆 [{$aliases[$winner]}](tg://user?id=$winner) برنده شد!", "Markdown");
                @unlink($playersFile);
                @unlink($gameFile);
                saveData($statsFile, $stats);
                return;
            }
            $game['current'] = $game['current'] % count($game['players']);
        } else {
            send($chat_id, "😰 [{$alias}](tg://user?id=$from_id) ماشه رو کشید... *کلیک* – زنده موند!", "Markdown");
            $game['current'] = ($game['current'] + 1) % count($game['players']);
        }

        $next = $game['players'][$game['current']];
        send($chat_id, "➡️ نوبت بعدی: [{$aliases[$next]}](tg://user?id=$next)", "Markdown");
        saveData($gameFile, $game);
        saveData($statsFile, $stats);
    }
}
?>