<?php
// setup.php

// ---------- تنظیمات ----------
$dataDir = __DIR__ . '/data';
$requiredFiles = [
    'access.json' => [],
    'stats.json' => [],
    'aliases.json' => []
];

// ---------- ایجاد پوشه داده‌ها ----------
if (!is_dir($dataDir)) {
    mkdir($dataDir, 0777, true);
    echo "[✔] پوشه data با موفقیت ساخته شد.\n";
} else {
    echo "[i] پوشه data قبلاً وجود داشت.\n";
}

// ---------- بررسی و ایجاد فایل‌های اصلی ----------
foreach ($requiredFiles as $file => $defaultContent) {
    $path = __DIR__ . "/$file";
    if (!file_exists($path)) {
        file_put_contents($path, json_encode($defaultContent, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo "[✔] فایل $file ساخته شد.\n";
    } else {
        echo "[i] فایل $file قبلاً وجود داشت.\n";
    }
}

echo "\n[√] راه‌اندازی کامل شد. حالا می‌تونی فایل اصلی ربات رو اجرا کنی.\n";
?>