<?php
// ---------- تنظیمات ----------
define('API_KEY', '7773852334:AAHHGRMKz5FufhSgGr9INIk8ahsVjI1Mx_M');
define('BOT_PASSWORD', 'Ars3663');

$accessFile = 'access.json';
$statsFile = 'stats.json';
$aliasesFile = 'aliases.json';
$dataDir = __DIR__ . '/data';

// ---------- توابع عمومی ----------
function bot($method, $datas = []) {
    $url = "https://api.telegram.org/bot" . API_KEY . "/" . $method;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $datas);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}

function send($chat_id, $text, $parse_mode = null, $reply_markup = null) {
    $data = ['chat_id' => $chat_id, 'text' => $text];
    if ($parse_mode) $data['parse_mode'] = $parse_mode;
    if ($reply_markup) $data['reply_markup'] = json_encode($reply_markup);
    bot('sendMessage', $data);
}

function loadData($file) {
    return file_exists($file) ? json_decode(file_get_contents($file), true) : [];
}

function saveData($file, $data) {
    file_put_contents($file, json_encode($data));
}

function sendMainPanel($chat_id) {
    $keyboard = [
        [['text' => '/join'], ['text' => '/leave']],
        [['text' => '/start_game'], ['text' => '/fire']],
        [['text' => '/setname'], ['text' => '/stats']],
        [['text' => '/setmode'], ['text' => '/help']]
    ];
    send($chat_id, "دستورات را از طریق پنل زیر انتخاب کن:", null, ['keyboard' => $keyboard, 'resize_keyboard' => true]);
}

function getGroupFile($chat_id, $name) {
    global $dataDir;
    if (!file_exists($dataDir)) mkdir($dataDir);
    return "$dataDir/{$chat_id}_$name.json";
}

// ---------- داستان مودها ----------
$modesStory = [
    'classic' => "*مود کلاسیک:*
در این مود همه‌چیز ساده‌ست. یه تفنگ، یه گلوله، چند دیوانه... هرکس جرأت داره ماشه رو بکشه، زنده می‌مونه... یا نه.",
    'revenge' => "*مود کینه‌جویانه:*
اگه کسی تو رو بکشه، در بازی بعدی می‌تونی ازش انتقام بگیری!",
    'fear' => "*مود ترس:*
خاموشی، سکوت، انتظار... ماشه رو بکش یا بمیر!"
];

// ---------- مدیریت پیام ----------
$update = json_decode(file_get_contents('php://input'), true);
$message = $update['message'] ?? null;

if ($message) {
    $chat_id = $message['chat']['id'];
    $from_id = $message['from']['id'];
    $name = $message['from']['first_name'] ?? '';
    $text = trim($message['text'] ?? '');

    // فایل‌های عمومی
    $access = loadData($accessFile);
    $stats = loadData($statsFile);
    $aliases = loadData($aliasesFile);

    // فایل‌های گروهی
    $playersFile = getGroupFile($chat_id, 'players');
    $gameFile = getGroupFile($chat_id, 'game');
    $players = loadData($playersFile);
    $game = loadData($gameFile);

    $alias = $aliases[$from_id] ?? $name;

    if (!isset($access[$from_id])) {
        if ($text == '/start') {
            send($chat_id, "🎯 *به بازی مرگ خوش اومدی!*

برای ورود باید رمز عبور رو بزنی.

*آیا جرأت ورود به این بازی مرگبار رو داری؟*", "Markdown");
        } elseif ($text == BOT_PASSWORD) {
            $access[$from_id] = true;
            saveData($accessFile, $access);
            send($chat_id, "✅ *دسترسی تأیید شد!*

حالا می‌تونی وارد بازی بشی...
برای شروع، دستور /join رو بزن.", "Markdown");
            sendMainPanel($chat_id);
        } else {
            send($chat_id, "❌ *رمز اشتباهه!* 
یا اشتباه تایپ کردی یا نمی‌خوای زنده بمونی...", "Markdown");
        }
        return;
    }

    if ($text == '/start') {
        send($chat_id, "💀 *به بازی Ars rulخوش اومدی شرکت کننده عزیز!*

از دکمه‌ها برای اجرای دستورات استفاده کن.", "Markdown");
        sendMainPanel($chat_id);
    } elseif (str_starts_with($text, '/setname')) {
        $aliasName = trim(str_replace('/setname', '', $text));
        if ($aliasName) {
            $aliases[$from_id] = $aliasName;
            saveData($aliasesFile, $aliases);
            send($chat_id, "✏️ نام مستعار شما به '$aliasName' تنظیم شد.");
        } else {
            send($chat_id, "⚠️ لطفاً بعد از /setname یک نام بنویس.");
        }
    } elseif ($text == '/stats') {
        $userStats = $stats[$from_id] ?? ['wins' => 0, 'deaths' => 0, 'plays' => 0];
        send($chat_id, "📊 آمار شما:
بردها: {$userStats['wins']}
مرگ‌ها: {$userStats['deaths']}
تعداد بازی‌ها: {$userStats['plays']}");
    } elseif (str_starts_with($text, '/setmode')) {
        $mode = trim(str_replace('/setmode', '', $text));
        if (isset($modesStory[$mode])) {
            $game['mode'] = $mode;
            saveData($gameFile, $game);
            send($chat_id, "🎮 مود بازی به '$mode' تنظیم شد.");
            send($chat_id, $modesStory[$mode], "Markdown");
        } else {
            send($chat_id, "⚠️ مود نامعتبر. مودهای موجود: classic ، revenge ، fear");
        }
    } elseif ($text == '/help') {
        $help = "🆘 راهنمای بازی:

/start - شروع و دریافت راهنما
/join - ورود به بازی
/leave - خروج از بازی
/setname [نام] - انتخاب نام مستعار
/stats - دیدن آمار
/setmode [classic|revenge|fear] - تنظیم مود بازی
/start_game - شروع بازی
/fire - کشیدن ماشه
/end - پایان بازی

مودها:";
        foreach ($modesStory as $desc) $help .= "

$desc";
        send($chat_id, $help, "Markdown");
    } elseif ($text == '/join') {
        if (!empty($game['started'])) {
            send($chat_id, "🚫 بازی در حال اجراست.");
        } elseif (!in_array($from_id, $players)) {
            $players[] = $from_id;
            saveData($playersFile, $players);
            send($chat_id, "☠️ $alias به بازی پیوست.");
        } else {
            send($chat_id, "⚠️ قبلاً وارد بازی شدی.");
        }
    } elseif ($text == '/leave') {
        if (($key = array_search($from_id, $players)) !== false) {
            unset($players[$key]);
            saveData($playersFile, array_values($players));
            send($chat_id, "🚶 $alias از بازی خارج شد.");
        } else {
            send($chat_id, "❓ شما در بازی نیستید.");
        }
    } elseif ($text == '/start_game') {
        if (count($players) < 2) {
            send($chat_id, "🧍‍♂️ حداقل ۲ بازیکن نیاز است.");
        } else {
            foreach ($players as $pid) $stats[$pid]['plays'] = ($stats[$pid]['plays'] ?? 0) + 1;
            $startIndex = rand(0, count($players) - 1);
            $game = [
                'started' => true,
                'players' => $players,
                'current' => $startIndex,
                'mode' => $game['mode'] ?? 'classic'
            ];
            saveData($gameFile, $game);
            $list = "🕯️ صدای چرخش خشاب در دل سکوت پیچید...

🕳️ شش خانه. یک گلوله. و چند نفس بی‌قرار.

🎮 بازی مرگ آغاز شد. بازیکنان:";
            foreach ($players as $pid) {
                $a = $aliases[$pid] ?? $pid;
                $list .= "🔫 [$a](tg://user?id=$pid)
";
            }
            $first = $game['players'][$startIndex];
            send($chat_id, "$list

🔥 نوبت اول: [{$aliases[$first]}](tg://user?id=$first)", "Markdown");
            saveData($statsFile, $stats);
        }
    } elseif ($text == '/end') {
        @unlink($playersFile);
        @unlink($gameFile);
        send($chat_id, "🛑 بازی متوقف شد.");
    } elseif ($text == '/fire') {
        if (empty($game['started'])) {
            send($chat_id, "⏳ بازی هنوز شروع نشده.");
            return;
        }
        $currentPlayer = $game['players'][$game['current']];
        if ($from_id != $currentPlayer) {
            send($chat_id, "❗ نوبت شما نیست!");
            return;
        }

        $bullet = rand(1, 6);
        if ($bullet == 1) {
            send($chat_id, "[{$alias}](tg://user?id=$from_id) چشمانش را بست...

*تق.* 💥

🩸☠️ مغز دیوار را نقاشی کرد.

🪦 او رفت.", "Markdown");
            $stats[$from_id]['deaths'] = ($stats[$from_id]['deaths'] ?? 0) + 1;
            unset($game['players'][$game['current']]);
            $game['players'] = array_values($game['players']);
            if (count($game['players']) == 1) {
                $winner = $game['players'][0];
                $stats[$winner]['wins'] = ($stats[$winner]['wins'] ?? 0) + 1;
                send($chat_id, "🏁 بازی تمام شد.

🏆🧍 بازمانده: [{$aliases[$winner]}](tg://user?id=$winner)

ولی این فقط یک دور بود...
حالا اون می‌تواند با پول هایی که جمع کرده به خانه برگرده یا شایدن نه ... کسی چه میداند

🌀 هنوز صدای چرخش خشاب توی سرت می‌پیچه.", "Markdown");
                @unlink($playersFile);
                @unlink($gameFile);
                saveData($statsFile, $stats);
                return;
            }
            $game['current'] = $game['current'] % count($game['players']);
        } else {
            send($chat_id, "😰 [{$alias}](tg://user?id=$from_id) ماشه را کشید...
*کلیک.* 🔇
🩸 هیچ صدایی نیامد... فقط نفس‌هایی بریده‌بریده.

✅ زنده ماند. فعلاً...", "Markdown");
            $game['current'] = ($game['current'] + 1) % count($game['players']);
        }

        $next = $game['players'][$game['current']];
        send($chat_id, "🎯 نوبت [{$aliases[$next]}](tg://user?id=$next)فرا رسید...
🤲 دستانی لرزان، 👁️ نگاهی خیره، و یک تصمیم مرگبار.
🔫 اسلحه حالا در دستان اوست...
", "Markdown");
        saveData($gameFile, $game);
        saveData($statsFile, $stats);
    }
}
?>
